{-------------------------------------------------------------------------}

{ Initialisierung des Grafik-Bildschirmes und Ausgabe der Grafik }
unit Anzeige;

{-------------------------------------------------------------------------}

interface

uses
  DGLGlob,

  { Turbo Pascal Standard Units }
  Crt, Dos, Graph, GraphApp, MsgBox, Objects;

procedure Grafik;

{-------------------------------------------------------------------------}

implementation

{-------------------------------------------------------------------------}

{ Initialisierung des Grafik-Bildschirmes }
procedure Grafik;

{-------------------------------------------------------------------------}

{ Ausgabe der Grafik }
procedure GrafikAnzeige;

var
  i, j  : integer;
  Strng : string;

begin
  { feste Elemente einfgen }
  Rectangle(0, 0, GetMaxX, GetMaxY);
  Line(0, 459, GetMaxX, 459);
  Line(485, 459, 485, GetMaxY);
  Strng := 'Weiter mit <ESC>';
  OutTextXY(500, 466, Strng);

  { Differential-Gleichung ausgeben }
  Strng := 'dy/dx = '+DiffGl;
  OutTextXY(15, 466, Strng);

  { Koordinatenkreuz zeichnen }
  Line(Skala[0], Skala[1], Skala[2], Skala[1]);
  OutTextXY(Skala[2]-20, Skala[1]-10, 'x');
  Line(Skala[3], Skala[4], Skala[3], Skala[5]);
  OutTextXY(Skala[3]-10, Skala[4]+10, 'y');

  { Skalenstriche zeichnen und Skalenbeschriftung }
  i := 19+Skala[6];
  j := 0;
  repeat
    if abs(Skala[3]-i) < 10 then i := Skala[3];
    Line(i, Skala[1]-3, i, Skala[1]+3);
    OutTextXY(i-30, Skala[1]+8, x_Beschriftung[j]);
    i := i+Skala[6];
    inc(j);
  until i > 604;
  i := 439-Skala[7];
  j := 0;
  repeat
    if abs(Skala[1]-i) < 10 then i := Skala[1];
    Line(Skala[3]-3, i, Skala[3]+3, i);
    if Skala[3] < 559 then
      OutTextXY(Skala[3]+8, i-3, y_Beschriftung[j])
    else OutTextXY(Skala[3]-10*length(y_Beschriftung[j])+10, i-3,
      y_Beschriftung[j]);
    i := i-Skala[7];
    inc(j);
  until i < 34;

  { Hilfspunkte zeichnen }
  i := 19;
  repeat
    if abs(Skala[3]-i) < 10 then i := Skala[3];
    j := 439;
    repeat
      if abs(Skala[1]-j) < 10 then j := Skala[1];
      PutPixel(i, j, white);
      PutPixel(619, j, white);
      j := j-Skala[7];
    until j < 34;
    PutPixel(i, 19, white);
    i := i+Skala[6];
  until i > 604;
  PutPixel(619, 19, white);

  { Funktion zeichnen }
  for i := 0 to nd do PutPixel(dw[i].x, dw[i].y, yellow);
end; { GrafikAnzeige }

{-------------------------------------------------------------------------}

var
  BGIPath : PString;
  GraphOk : boolean;
  Taste   : char;

begin { Grafik }
  BGIPath := NewStr(FExpand('.'));
  GraphOk := GraphAppInit(0, 0, BGIPath, true);
  if not GraphOk then
    MessageBox(#3+'Kann Grafiktreiber nicht finden', nil,
      mfOKButton or mfError);
  if GraphicsStart then
  begin
    GrafikAnzeige;
    repeat
      Taste := readkey
    until Taste in [chr(27)]; { Escape-Taste }
    GraphicsStop;
  end;
end; { Grafik }

{-------------------------------------------------------------------------}

end. { Anzeige }

{-------------------------------------------------------------------------}