{-------------------------------------------------------------------------}

{ Erzeugung des Formel-Codes aus der Differential-Gleichung und Berechnung
  der K-Werte mit dem Formel-Code }
unit Compil;

{-------------------------------------------------------------------------}

interface

uses
  DGLGlob, Error,

  { Turbo Pascal Standard Units }
  MsgBox, Objects, Views;

function Rechne(var Code; x, y : real): real;
procedure Compile(var Ausdruck; var Code; Size : integer;
  Meldung : boolean; var ErrPos, Pc : integer);

{-------------------------------------------------------------------------}

implementation

var
  CpuSave : ExitBuf;

{-------------------------------------------------------------------------}

{ Berechnung der K-Werte mit dem Formel-Code }
function Rechne(var Code; x, y : real) : real;

const
  MaxStack = 50;

var
  Pc, Sp : integer;
  Oc     : byte;
  Stack  : array [0..MaxStack] of real;
  OpCode : array [0..MaxInt] of byte absolute Code;

begin
  Pc := 0;
  Sp := 0;
  repeat
    Oc := OpCode[Pc];
    Inc(Pc);
    case Oc of
      0  : begin
             Inc(Sp);
	     Stack[Sp] := x;
           end;
      1  : begin
             Inc(Sp);
	     Stack[Sp] := y;
           end;
      2  : begin
             Inc(Sp);
	     Move(OpCode[Pc], Stack[Sp], SizeOf(real));
	     Inc(Pc, SizeOf(real));
           end;
      3  : begin
             Dec(Sp);
	     Stack[Sp] := Stack[Sp]+Stack[Succ(Sp)];
           end;
      4  : begin
             Dec(Sp);
	     Stack[Sp] := Stack[Sp]-Stack[Succ(Sp)];
           end;
      5  : begin
             Dec(Sp);
	     Stack[Sp] := Stack[Sp]*Stack[Succ(Sp)];
           end;
      6  : begin
             Dec(Sp);
	     Stack[Sp] := Stack[Sp]/Stack[Succ(Sp)];
           end;
      7  : Stack[Sp] := Sin(Stack[Sp]);
      8  : Stack[Sp] := Cos(Stack[Sp]);
      9  : Stack[Sp] := Sin(Stack[Sp])/Cos(Stack[Sp]);
      10 : Stack[Sp] := ArcTan(Stack[Sp]);
      11 : Stack[Sp] := Exp(Stack[Sp]);
      12 : Stack[Sp] := Ln(Stack[Sp]);
      13 : Stack[Sp] := Ln(Stack[Sp])/Ln(10.0);
      14 : Stack[Sp] := Sqr(Stack[Sp]);
      15 : Stack[Sp] := Sqrt(Stack[Sp]);
      16 : Stack[Sp] := Frac(Stack[Sp]);
      17 : Stack[Sp] := Int(Stack[Sp]);
      18 : Stack[Sp] := Abs(Stack[Sp]);
      19 : Stack[Sp] := -Stack[Sp];
    end;
  until Oc >= 20;
  Rechne := Stack[1];
end; { Rechne }

{-------------------------------------------------------------------------}

{ Erzeugung des Formel-Codes aus der Differential-Gleichung }
procedure Compile(var Ausdruck; var Code; Size : integer;
  Meldung : boolean; var ErrPos, Pc : integer);

type
  RunTime = (LoadVarX, LoadVarY, Push, Add, Sub, Mult, Divi, Sin, Cos,
    Tan, ArcTan, Exp, Ln, Log, Sqr, Sqrt, Frac, Int, Abs, Neg, Stop);
  Str1 = string [1];

const
  FNam : array [Sin..Abs] of string [6] = ('SIN', 'COS', 'TAN', 'ARCTAN',
    'EXP', 'LN', 'LOG', 'SQR', 'SQRT', 'FRAC', 'INT', 'ABS');

var
  Formel     : string [255] absolute Ausdruck;
  OpCode     : array [0..MaxInt] of Runtime absolute Code;
  Chp, Tiefe : integer;
  K, Dummy   : word;
  Ch         : char;

{-------------------------------------------------------------------------}

procedure Fehler(Nr : integer);

var
  i, j : integer;
  R    : TRect;
  Strng, Strng1 : string;

begin
  if Meldung then
  begin
    case Nr of
      0 : Strng1 := 'Speicherplatz im Codefeld reicht nicht';
      1 : Strng1 := 'Operator erwartet';
      2 : Strng1 := '"(" erwartet';
      3 : Strng1 := 'Unbekannte Funktion';
      4 : Strng1 := '")" erwartet';
      5 : Strng1 := 'Konstante, Variable oder Funktion erwartet';
      6 : Strng1 := 'Fehler in Konstante';
      7 : Strng1 := 'Klammer-Fehler'
    end;
    Strng := '';
    for i := 1 to Chp-1 do Strng := Strng + ' ';
    Strng := Strng + '^';
    j := Length(Strng);
    for i := j+1 TO Length(Formel) do Strng := Strng + ' '
  end;
  if ErrPos = 0 then ErrPos := Chp;
  R.Assign(13, 6, 67, 17);
  MessageBoxRect(R, #3+Formel+#13+#3+Strng+#13+#13+#3+Strng1, nil,
    mfError or mfOKButton);
  LongExit(CpuSave, Dummy);
end; { Fehler }

{-------------------------------------------------------------------------}

procedure GetChar;

begin
  repeat
    Inc(Chp);
    if Chp > Length(Formel) then Ch := #0 else Ch := Upcase(Formel[Chp]);
  until Ch <> ' '
end; { GetChar }

{-------------------------------------------------------------------------}

procedure PutCode(B : Runtime);

begin
  if Pc >= Size then Fehler(0) else OpCode[Pc] := B;
  Inc(Pc)
end; { PutCode }

{-------------------------------------------------------------------------}

procedure PutReal(R : real);

begin
  if Pc + SizeOf(real) >= Size then Fehler(0)
    else Move(R, Opcode[Pc], SizeOf(real));
  Inc(Pc,SizeOf(real))
end; { PutReal }

{-------------------------------------------------------------------------}

procedure AddSub; Forward;

{-------------------------------------------------------------------------}

procedure Konstante (var Vorz : Str1);

var
  Fp         : real;
  Err1, Err2 : integer;

begin
  Val(Copy(Formel, Chp, 255)+'?', Fp, Err1);
  Val(Vorz+Copy(Formel, Chp, pred(err1)), fp, Err2);
  if Err2 <> 0 then Fehler(6);
  PutCode(Push);
  PutReal(Fp);
  Chp := Chp + Err1 - 2;
  GetChar;
  if not (Ch in ['-','+','/','*',')',#0]) then Fehler(1)
end; { Konstante }

{-------------------------------------------------------------------------}

procedure Term;

var
  Name : string [6];
  i, S : Runtime;
  Vorz : Str1;

begin
  GetChar;
  if Ch in [#0,')'] then
  begin
    Fehler(5);
    Exit
  end;
  if Ch = '-' then
  begin
    Vorz := '-';
    GetChar
  end
  else Vorz := '';
  if Ch = '(' then
  begin
    Inc(Tiefe);
    AddSub;
    Dec(Tiefe);
    if Ch <> ')' then
    begin
      Fehler(4);
      Exit
    end;
    GetChar
  end
  else
  if Ch in ['0'..'9'] then Konstante(Vorz)
  else
  begin
    Name := '';
    while Ch in ['A'..'Z'] do
    begin
      Name := Name + Ch;
      GetChar
    end;
    if Name = 'X' then PutCode(LoadVarX);
    if Name = 'Y' then PutCode(LoadVarY);
    if (Name <> 'X') and (Name <> 'Y') then
    begin
      S := LoadVarX;
      for i := Sin to Abs do if Name = FNam[i] then S := I;
      S := LoadVarY;
      for i := Sin to Abs do if Name = FNam[i] then S := I;
      if (S <> LoadVarX) or (S <> LoadVarY) then
      begin
	if Ch <> '(' then Fehler(2);
        Dec(Chp);
	Term;
        PutCode(S);
      end
      else Fehler(3);
    end;
    if Vorz = '-' then PutCode(Neg)
  end;
end; { Term }

{-------------------------------------------------------------------------}

procedure MultDiv;

begin
  repeat
    case Ch of
      '*' : begin
              Term;
	      PutCode(Mult)
            end;
      '/' : begin
              Term;
	      PutCode(Divi)
            end;
    end;
  until not (Ch in ['*', '/']);
end; { MultDiv }

{-------------------------------------------------------------------------}

procedure AddSub;

begin
  Term;
  if ErrPos = 0 then
  repeat
    case Ch of
      '-'      : begin
                   Term;
	           MultDiv;
	           PutCode(Sub)
                 end;
      '+'      : begin
                   Term;
	           MultDiv;
	           PutCode(Add)
                 end;
      '('      : Fehler(1);
      ')'      : begin
	           if Tiefe = 0 then Fehler(7);
                   Exit;
                 end;
      '*', '/' : MultDiv;
      #0       :
      else Fehler(1);
    end;
  until (Ch = #0) or (ErrPos <> 0);
end; { AddSub }

{-------------------------------------------------------------------------}

begin { Compile }
  K := SetExit(CpuSave);
  if K = 0 then
  begin
    Chp := 0;
    Pc := 0;
    ErrPos := 0;
    Tiefe := 0;
    AddSub;
    PutCode(Stop)
  end;
end; { Compile }

{-------------------------------------------------------------------------}

end. { Compil }

{-------------------------------------------------------------------------}