{-------------------------------------------------------------------------}

{ Programm zur numerischen Lsung von expliziten Differential-Gleichungen
  erster Ordnung
  Udo Becker 1996/97 }

program DGL;

{$X+}
{$S+}
{$M 65520,8192,655360}

{-------------------------------------------------------------------------}

uses
  DGLGlob, Etc, Input, LoadSave,

  { Turbo Pascal Standard Units }
  App, Drivers, Gadgets, Memory, Menus, Objects, Views;

type
  TDGL = object(TApplication)
    Clock : PClockView;
    Heap  : PHeapView;
    constructor Init;
    procedure HandleEvent(var Event : TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

const
  HeapSize = 48 * (1024 div 16); { 48k Heap }

{-------------------------------------------------------------------------}

{ Initialisierung }
constructor TDGL.Init;

var
  R : TRect;

begin
  MaxHeapSize := HeapSize;
  inherited Init;
  GetExtent(R);
  R.A.X := R.B.X - 9;
  R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);
  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9;
  R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);
  Info;
end; { Init }

{-------------------------------------------------------------------------}

{ Auswahl der Handlungsmglichkeiten }
procedure TDGL.HandleEvent(var Event: TEvent);

begin
  inherited HandleEvent(Event);
  case Event.What of evCommand:
    begin
      case Event.Command of
        cmEingabe : Eingabe;
        cmLaden   : Laden;
        cmRechner : Rechner;
        cmInfo    : Info;
      else
        Exit;
      end;
      ClearEvent(Event);
    end;
  end;
end; { HandleEvent }

{-------------------------------------------------------------------------}

{ Uhrzeit und Speicherbelegung aktualisieren }
procedure TDGL.Idle;

begin
  inherited Idle;
  Clock^.Update;
  Heap^.Update;
end; { Idle }

{-------------------------------------------------------------------------}

{ Menleiste }
procedure TDGL.InitMenuBar;

var
  R : TRect;

begin
  GetExtent(R);
  R.B.Y := R.A.Y+1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewItem('~E~ingabe', '', kbNoKey, cmEingabe, hcEingabe,
    NewItem('~L~aden', '', kbNoKey, cmLaden, hcLaden,
    NewItem('~T~-Rechner', '', kbNoKey, cmRechner, hcRechner,
    NewItem('~I~nfo', '', kbNoKey, cmInfo, hcInfo,
    nil)))))));
end; { InitMenuBar }

{-------------------------------------------------------------------------}

{ Statuszeile }
procedure TDGL.InitStatusLine;

var
  R : TRect;

begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey('~Esc~ Fenster schlieen', kbEsc, cmClose,
      nil))),
    nil)));
end; { InitStatusLine }

{-------------------------------------------------------------------------}

var
  DG : TDGL;

begin { DGL }
  with DG do
  begin
    Init;
    Run;
    Done;
  end;
end. { DGL }

{-------------------------------------------------------------------------}
