{-------------------------------------------------------------------------}

{ Deklarierung globaler Typen, Konstanten, Variablen, Funktionen und
  Prozeduren }
unit DGLGlob;

{$D-}

{-------------------------------------------------------------------------}

interface

type
  RParameter = record
    DGLEingabe : string;
    Eingaben   : array [0..3] of string [12];
  end;
  DarstellWerte = record
    x, y : word;
  end;

const
  cmInfo    = 1002;
  cmRechner = 1006;
  cmEingabe = 1007;
  cmLaden   = 1008;
  hcRechner = 4;
  hcInfo    = 8;
  hcEingabe = 21;
  hcLaden   = 22;
  dw_max    = 5000;

var
  Parameter                        : RParameter;
  DiffGl                           : string;
  x_min, x_max, y_anfang, e        : real;
  nd                               : word;
  dw                               : array [0..dw_max] of DarstellWerte;
  Skala                            : array [0..11] of word;
  n_xBeschriftung, n_yBeschriftung : byte;
  x_Beschriftung, y_Beschriftung   : array [0..9] of string;
  FormelCode                       : array [0..1000] of word;
  Fehler, FehlerCode               : integer;
  Ok                               : boolean;

function Exists(Fn : string) : boolean;
procedure ValueR(Param : string; var a : real);
procedure ValueI(Param : string; var i : integer);

{-------------------------------------------------------------------------}

implementation

{--------------------------------------------------------------------------}

{ Prfung ob eine Datei vorhanden ist }
function Exists(Fn : string) : boolean;

var
  Datei : file;

begin
  Assign(Datei, Fn);
  {$I-}
  Reset(Datei);
  {$I+}
  if IOResult = 0 then
  begin
    Exists := true;
    Close(Datei);
  end
  else Exists := false;
end; { Exists }

{--------------------------------------------------------------------------}

{ Konvertierung eines String in einen Real-Wert }
procedure ValueR(Param : string; var a : real);

begin
  Val(Param, a, Fehler);
  Ok := Ok and (Fehler = 0)
end; { ValueR }

{-------------------------------------------------------------------------}

{ Konvertierung eines String in einen Integer-Wert }
procedure ValueI(Param : string; var i : integer);

begin
  Val(Param, i, Fehler);
  Ok := OK and (Fehler = 0)
end;

{-------------------------------------------------------------------------}

end. { DGLGlob }

{--------------------------------------------------------------------------}