{-------------------------------------------------------------------------}

{ Abfangen von Fehlern in der Berechnung }
unit Error;

{$F+}

{-------------------------------------------------------------------------}

interface

type
  ExitBuf = record
    Bp, Cs, Ip : word
  end;

var
  CpuPointer : ExitBuf;
  ErrCode    : word;

function SetExit(var CpuSave : ExitBuf) : word;
procedure LongExit(var CpuSave : ExitBuf; RetV : word);

{-------------------------------------------------------------------------}

implementation

var
  Stack : record
    case boolean of
      true  : (Offset, Segment : word);
      false : (Zeiger : ^word)
    end;
  ExitSave : pointer;

{-------------------------------------------------------------------------}

function SetExit(var CpuSave : ExitBuf) : word;

begin
  with Stack do
  begin
    Zeiger := Ptr(SSeg, SPtr+2);
    CpuSave.bp := Zeiger^;
    Inc(Offset, 2);
    CpuSave.ip := Zeiger^;
    Inc(Offset, 2);
    CpuSave.cs := Zeiger^
  end;
  SetExit := 0
end; { SetExit }

{-------------------------------------------------------------------------}

procedure LongExit(var CpuSave : ExitBuf; RetV : word);

var
  Dummy : word;

begin
  with Stack do
  begin
    Zeiger := Ptr(SSeg, SPtr+2);
    Zeiger^ := CpuSave.bp;
    Inc(Offset, 2);
    Zeiger^ := CpuSave.ip;
    Inc(Offset, 2);
    Zeiger^ := CpuSave.cs;
  end;
  Dummy := RetV
end; { LongExit }

{-------------------------------------------------------------------------}

procedure MyExit;

begin
  ExitProc := ExitSave;
  if ExitCode in [200, 205, 206, 207] then
  begin
    ErrCode := ExitCode;
    ExitCode := 0;
    ErrorAddr := nil;
    ExitProc := @MyExit;
    LongExit(CpuPointer, ErrCode)
  end;
end; { MyExit }

{-------------------------------------------------------------------------}

begin
  ExitSave := ExitProc;
  ExitProc := @MyExit
end. { Error }

{-------------------------------------------------------------------------}