{-------------------------------------------------------------------------}

{ Eingabe-Dialog und Prfung der Eingaben }
unit Input;

{-------------------------------------------------------------------------}

interface

uses
  Anzeige, Compil, DGLGlob, LoadSave, Rechnung,

  { Turbo Pascal Standard Units }
  App, Dialogs, MsgBox, Objects, Views;

procedure Eingabe;

{-------------------------------------------------------------------------}

implementation

{-------------------------------------------------------------------------}

{ Eingabe-Dialog und Prfung der Eingaben }
procedure Eingabe;

var
  R        : TRect;
  D, DD    : PDialog;
  Bruce    : PView;
  Command  : word;
  Strng    : string;
  AnzBytes : integer;

begin

  { Laden der Parameter fr das Eingabefenster }
  ParFileRead;

  repeat

    { Parameter der letzten Rechnung }
    Parameter.DGLEingabe := DiffGl;
    Str(x_min: 8: 4, Parameter.Eingaben[0]);
    Str(x_max: 8: 4, Parameter.Eingaben[1]);
    Str(y_anfang: 8: 4, Parameter.Eingaben[2]);
    Str(e: 11: 10, Parameter.Eingaben[3]);

    { Eingabefenster }
    R.Assign(3, 4, 77, 18);
    DD := New(PDialog,Init(R,'Eingabe'));
    DD^.HelpCtx := hcEingabe;
    with DD^ do
    begin

      { Feld fr Differential-Gleichung }
      R.Assign(11, 3, 71, 4);
      Bruce := New(PInputLine, Init(R, 255));
      Insert(Bruce);
      Strng := 'dy/dx =';
      R.Assign(2, 3, 3+Length(Strng), 4);
      Insert(New(PLabel, Init(R, Strng, Bruce)));
      Strng := 'Differential-Gleichung:';
      R.Assign(26, 2, 27+Length(Strng), 3);
      Insert(New(PStaticText, Init(R, Strng)));

      { Felder fr x-Wertebereich }
      R.Assign(32, 5, 46, 6);
      Bruce := New(PInputLine, Init(R, 12));
      Insert(Bruce);
      Strng := 'x_min =';
      R.Assign(20, 5, 21+Length(Strng), 6);
      Insert(New(PLabel, Init(R, Strng, Bruce)));
      R.Assign(57, 5, 71, 6);
      Bruce := New(PInputLine, Init(R, 12));
      Insert(Bruce);
      Strng := 'x_max =';
      R.Assign(48, 5, 49+Length(Strng), 6);
      Insert(New(PLabel, Init(R, Strng, Bruce)));
      Strng := 'x-Wertebereich:';
      R.Assign(3, 5, 3+Length(Strng), 6);
      Insert(New(PStaticText, Init(R, Strng)));

      { Feld fr y-Anfangswert }
      R.Assign(32, 7, 46, 8);
      Bruce := New(PInputLine, Init(R, 12));
      Insert(Bruce);
      Strng := 'y(x_min) =';
      R.Assign(20, 7, 21+Length(Strng), 8);
      Insert(New(PLabel, Init(R, Strng, Bruce)));
      Strng := 'y-Anfangswert:';
      R.Assign(3, 7, 4+Length(Strng), 8);
      Insert(New(PStaticText, Init(R, Strng)));

      { Feld fr Genauigkeit }
      R.Assign(32, 9, 46, 10);
      Bruce := New(PInputLine, Init(R, 12));
      Insert(Bruce);
      Strng := 'e =';
      R.Assign(20, 9, 21+Length(Strng), 10);
      Insert(New(PLabel, Init(R, Strng, Bruce)));
      Strng :=  'Genauigkeit:';
      R.Assign(3, 9, 4+Length(Strng), 10);
      Insert(New(PStaticText, Init(R, Strng)));

      { Buttons }
      R.Assign(21, 11, 31, 13);
      Insert(New(PButton, Init(R, '~B~ild', cmOk, bfDefault)));
      R.Assign(43, 11, 53, 13);
      Insert(New(PButton, Init(R, '~E~nde', cmCancel, bfNormal)));

      { Parameter einfgen }
      SetData(Parameter);

      Command := DeskTop^.ExecView(DD);
      if Command <> cmCancel then
      begin

        { Parameter einlesen }
        GetData(Parameter);
	Ok := true;
        DiffGl := Parameter.DGLEingabe;
        ValueR(Parameter.Eingaben[0], x_min);
	ValueR(Parameter.Eingaben[1], x_max);
	ValueR(Parameter.Eingaben[2], y_anfang);
	ValueR(Parameter.Eingaben[3], e);
        Ok := Ok and (x_min < x_max);

      end
      else Ok := false;

      if (Command = cmOk) and Ok then
      begin

        { Formel-Code erzeugen }
        Compile(DiffGl, FormelCode, SizeOf(FormelCode), true, Fehler,
	  AnzBytes);

	if Fehler = 0 then
        begin

          { Berechnung der Nhrung und der Darstellungs-Daten }
          Berechnung;

          if FehlerCode = 0 then
          begin

            { Grafik-Ausgabe }
            Grafik;

            { Option zum Speichern der Darstellungs-Daten }
            R.Assign(0, 0, 45, 9);
            D := New(PDialog, Init(R,'Speichern ?'));
            with D^ do
            begin
              Options := Options or ofCentered;
              R.Grow(-1, -1);
              Dec(R.B.Y, 3);
              Insert(New(PStaticText, Init(R, #13+^C'Daten speichern ?')));
              R.Assign(9, 6, 19, 8);
              Insert(New(PButton, Init(R, '~J~a', cmYes, bfDefault)));
              R.Assign(25, 6, 35, 8);
              Insert(New(PButton, Init(R, '~N~ein', cmNo, bfNormal)));
            end;
            Command := Desktop^.ExecView(D);
            if (Command = cmYes) then Speichern;
            Dispose(D, Done);

          end;
        end;
      end;
      if (Command = cmOk) and not Ok then
        MessageBox(#3+'Eingabefehler:'+#13+#3+'alle Werte Zahlen ?'+
          #13+#3+'x_min < x_max ?', nil, mfError or mfOkButton);
    end;
    Dispose(DD, Done)
  until (Command = cmCancel);

  { Speichern der Parameter aus dem Eingabefenster }
  ParFileWrite;

end; { Eingabe }

{-------------------------------------------------------------------------}

end. { Input }

{-------------------------------------------------------------------------}