{-------------------------------------------------------------------------}

{ Laden und Speichern von Dateien }
unit LoadSave;

{-------------------------------------------------------------------------}

interface

uses
  Anzeige, DGLGlob,

  { Turbo Pascal Standard Units }
  App, Dialogs, MsgBox, Objects, StdDlg, Views;

procedure ParFileRead;
procedure ParFileWrite;
procedure Laden;
procedure Speichern;

{-------------------------------------------------------------------------}

implementation

const
  ParFileName : string = 'DGL.PAR';
  Extens      : string = '*.DGL';

var
  ParamFile, DatFile : text;
  FileName           : string;

{-------------------------------------------------------------------------}

{ Laden der Parameter fr das Eingabefenster }
procedure ParFileRead;

begin
  if Exists(ParFileName) then
  begin
    Assign(ParamFile, ParFileName);
    Reset(ParamFile);
    ReadLn(ParamFile, DiffGl);
    ReadLn(ParamFile, x_min);
    ReadLn(ParamFile, x_max);
    ReadLn(ParamFile, y_anfang);
    ReadLn(ParamFile, e);
    Close(ParamFile)
  end
  else
  begin
    DiffGl := 'cos(x)*y';
    x_min := -8;
    x_max := 0;
    y_anfang := exp(sin(-8));
    e := 0.000000001;
  end;
end; { ParFileRead }

{-------------------------------------------------------------------------}

{ Speichern der Parameter aus dem Eingabefenster }
procedure ParFileWrite;

begin
  Assign(ParamFile, ParFileName);
  ReWrite(ParamFile);
  WriteLn(ParamFile, DiffGl);
  WriteLn(ParamFile, x_min);
  WriteLn(ParamFile, x_max);
  WriteLn(ParamFile, y_anfang);
  WriteLn(ParamFile, e);
  Close(ParamFile);
end; { ParFileWrite }

{-------------------------------------------------------------------------}

{ ffnen einer Darstellungs-Datei }
procedure Laden;

{-------------------------------------------------------------------------}

{ Laden der Daten einer Dartellungs_Datei }
procedure DatFileRead;

var
  i : word;

begin
  Assign(DatFile, FileName);
  Reset(DatFile);
  ReadLn(DatFile, DiffGl);
  for i := 0 to 7 do ReadLn(DatFile, Skala[i]);
  ReadLn(Datfile, n_xBeschriftung);
  for i := 0 to n_xBeschriftung do ReadLn(Datfile, x_Beschriftung[i]);
  ReadLn(Datfile, n_yBeschriftung);
  for i := 0 to n_yBeschriftung do ReadLn(Datfile, y_Beschriftung[i]);
  ReadLn(DatFile, nd);
  for i := 0 to nd do
  begin
    ReadLn(DatFile, dw[i].x);
    ReadLn(DatFile, dw[i].y);
  end;
  Close(DatFile);
end; { DatFileRead }

{-------------------------------------------------------------------------}

var
  R       : TRect;
  D       : PFileDialog;
  Command : word;

begin  { Laden }
  repeat
    D := New(PFileDialog, Init(Extens, 'Datei ffnen', '~N~ame',
           fdOpenButton, fdReplaceButton));
    Command := Desktop^.ExecView(D);
    if (Command <> cmCancel) then
    begin
      D^.GetFileName(FileName);
      if Exists(FileName) then
      begin
        DatFileRead;
        Grafik;
      end
      else MessageBox(#3+'Datei nicht gefunden'+#13+#13, nil,
             mfError or mfOKButton);
    end;
    Dispose(D, Done);
  until (Command = cmCancel);
end; { Laden }

{-------------------------------------------------------------------------}

{ Abspeichern einer Darstellungs-Datei }
procedure Speichern;

{-------------------------------------------------------------------------}

{ Speichern der Daten einer Darstellungs-Datei }
procedure DatFileWrite;

var
  i : word;

begin
  Assign(DatFile, FileName);
  ReWrite(DatFile);
  WriteLn(DatFile, DiffGl);
  for i := 0 to 7 do WriteLn(DatFile, Skala[i]);
  WriteLn(Datfile, n_xBeschriftung);
  for i := 0 to n_xBeschriftung do WriteLn(Datfile, x_Beschriftung[i]);
  WriteLn(Datfile, n_yBeschriftung);
  for i := 0 to n_yBeschriftung do WriteLn(Datfile, y_Beschriftung[i]);
  WriteLn(DatFile, nd);
  for i := 0 to nd do
  begin
    WriteLn(DatFile, dw[i].x);
    WriteLn(DatFile, dw[i].y);
  end;
  Close(DatFile);
end; { DatFileWrite }

{-------------------------------------------------------------------------}

var
  R      : TRect;
  D      : PFileDialog;

begin { Speichern }
  Ok := false;
  repeat
    D := New(PFileDialog, Init(Extens, 'Datei speichern', '~N~ame',
      fdOkButton, fdReplaceButton));
    if Desktop^.ExecView(D) <> cmCancel then
    begin
      D^.GetFileName(FileName);
      if Exists(FileName) then
      begin
        if MessageBox(#3+'Datei existiert!'+#13+#3+'berschreiben?',
             nil, mfInformation or mfOkCancel) = cmOk then
	begin
          Assign(DatFile, FileName);
	  Erase(DatFile);
	  DatFileWrite;
          Ok := true;
	end;
      end
      else DatFileWrite;
      Ok := true
    end
    else Ok:= true;
    Dispose(D, Done);
  until Ok = true;
end; { Speichern }

{-------------------------------------------------------------------------}

end. { LoadSave }

{-------------------------------------------------------------------------}