{-------------------------------------------------------------------------}

{ Berechnung der Nhrung und der Darstellungs-Daten }
unit Rechnung;

{-------------------------------------------------------------------------}

interface

uses
  Compil, DGLGlob, Error,

  { Turbo Pascal Standard Units }
  MsgBox, Objects;

procedure DarstellBer;
procedure SkalaBer;
procedure Naehrung;
procedure Berechnung;

{-------------------------------------------------------------------------}

implementation

var
  x_next, x_last, x_skal, x_minskal, x_maxskal, x_faktor,
  y_next, y_last, y_skal, y_minskal, y_maxskal, y_faktor,
  y_min, y_max                                            : real;

{-------------------------------------------------------------------------}

{ Berechnung Darstellungs-Daten fr die Funktion mit erneuter Berechnung
  der Nhrung }
procedure DarstellBer;

var
  i, x_tmp, y_tmp                      : integer;
  h, s, y4, y5, k1, k2, k3, k4, k5, k6 : real;

begin
  i := 1;
  dw[0].x := round((x_min-x_minskal)*x_faktor)+19;
  dw[0].y := -(round((y_anfang-y_minskal)*y_faktor)-419)+19;
  x_last := x_min;
  y_last := y_anfang;
  h := (x_max-x_min)/100;
  repeat
    repeat

      { nchster x-Wert }
      x_next := x_last + h;

      { K-Werte }
      k1 := Rechne(FormelCode, x_last, y_last);
      k2 := Rechne(FormelCode, x_last+h/2, y_last+h*k1/2);
      k3 := Rechne(FormelCode, x_last+h/2, y_last+h*(k1+k2)/4);
      k4 := Rechne(FormelCode, x_last+h, y_last+h*(-k2+2*k3));
      k5 := Rechne(FormelCode, x_last+2*h/3, y_last+h*(7*k1+10*k2+k4)/27);
      k6 := Rechne(FormelCode, x_last+h/5,
              y_last+h*(28*k1-125*k2+546*k3+54*k4-378*k5)/625);

      { Nhrung 4. Ordnung }
      y4 := y_last+h*(k1+4*k3+k4)/6;

      { Nhrung 5. Ordnung }
      y5 := y_last+h*(14*k1+35*k4+162*k5+125*k6)/336;

      { s-Parameter }
      if y4 = y5 then s := 1 else s := sqrt(sqrt(h*e/abs(y4-y5)));

      { Schrittweite h verkleinern }
      if s < 1 then if s > 1/2 then h := s*h else h := h/2;

      { Schrittweite h zu klein, endlose Rekursion vermeiden }
      if h < (x_max-x_min)/1000000 then h := (x_max-x_min)/1000000;

    until (s >= 1) or (h  <= (x_max-x_min)/999999);

    { berechneten y-Wert bernehmen }
    y_next := y5;

    { Schrittweite h vergrern }
    if s >= 1 then if s < 2 then h := s*h else h := 2*h;

    x_last := x_next;
    y_last := y_next;

    { Darstellungs-Daten bestimmen }
    x_tmp := round((x_next-x_minskal)*x_faktor)+19;
    y_tmp := -(round((y_next-y_minskal)*y_faktor)-419)+19;
    if (x_tmp <> dw[i-1].x) or (y_tmp <> dw[i-1].y) then
    begin
      dw[i].x := x_tmp;
      dw[i].y := y_tmp;
      inc(i);
    end;

  until (x_last >= x_max) or (i = dw_max);
  nd := i-1;
end; { DarstellBer }

{-------------------------------------------------------------------------}

{ Berechnung der Darstellungs-Daten fr das Koordinaten-System }
procedure SkalaBer;

{-------------------------------------------------------------------------}

{ Berechnung von Zehnerpotenzen aus dem Exponenten }
function Zehnerpotenz(Exponent : integer) : real;

var
  i        : integer;
  Ergebnis : real;
  Strng    : string;

begin
  Strng := '1';
  if Exponent > 0 then for i := 1 to Exponent do Strng := Strng+'0';
  if Exponent < -1 then for i := -2 downto Exponent do Strng := '0'+Strng;
  if Exponent < 0 then Strng := '0.'+Strng;
  ValueR(Strng, Ergebnis);
  Zehnerpotenz := Ergebnis;
end; { Zehnerpotenz }

{-------------------------------------------------------------------------}

var
  i, sig, exp     : integer;
  skalmitte, tmpR : real;
  tmpS            : string [24];
  abschneiden     : boolean;

begin { SkalBer }

  { x-Skalenweite }
  tmpR := (x_max-x_min)/8;
  str(tmpR, tmpS);
  ValueI(copy(tmpS, 2, 1), sig);
  ValueI(copy(tmpS, 19, 5), exp);
  case sig of
    0    : x_skal := 1;
    1    : x_skal := 2;
    2..4 : x_skal := 5;
    5..9 : x_skal := 10;
  end;
  x_skal := x_skal*(Zehnerpotenz(exp));

  { Mitte der x-Skala }
  skalmitte := (x_min+x_max)/2;
  if skalmitte >= 0 then
  begin
    tmpR := -x_skal;
    repeat
      tmpR := tmpR+x_skal;
    until skalmitte-tmpR <= 0;
    skalmitte := tmpR;
  end
  else
  begin
    tmpR := x_skal;
    repeat
      tmpR := tmpR-x_skal;
    until skalmitte-tmpR >= 0;
    skalmitte := tmpR;
  end;

  { x-Minimal- und -Maximal-Skalenwert }
  x_minskal := skalmitte;
  repeat
    x_minskal := x_minskal-x_skal;
  until x_minskal < x_min+0.1*x_skal;
  x_maxskal := skalmitte;
  repeat
    x_maxskal := x_maxskal+x_skal;
  until x_maxskal > x_max-0.1*x_skal;

  { x-Skalenbeschriftung }
  i := 0;
  tmpR := x_minskal;
  repeat
    tmpR := tmpR+x_skal;
    if abs(tmpR) > 0.5*x_skal then
    begin
      Str(tmpR, tmpS);
      if exp < 0 then
      begin
        if copy(tmpS, 4-exp, 1) = '9' then
        begin
          tmpR := tmpR+0.1*Zehnerpotenz(exp);
          Str(tmpR, tmpS);
        end;
        x_Beschriftung[i] :=
          copy(tmpS, 1, 3-exp)+copy(tmpS, 18, 2)+copy(tmpS, 22, 2);
      end
      else x_Beschriftung[i] :=
        copy(tmpS, 1, 4)+copy(tmpS, 18, 2)+copy(tmpS, 22, 2);
    end
    else
    begin
      tmpR := 0;
      x_Beschriftung[i] := '';
    end;
    inc(i);
  until tmpR >= x_maxskal-0.5*x_skal;
  n_xBeschriftung := i-1;

  { nichtsignifikante x-Stellen abschneiden }
  repeat
    abschneiden := false;
    if length(x_Beschriftung[i]) > 8 then
    begin
      i := -1;
      repeat
        abschneiden := false;
        inc(i);
        if copy(x_Beschriftung[i], length(x_Beschriftung[i])-4, 1) = '0'
          then abschneiden := true;
      until (abschneiden = false) or (i = n_xBeschriftung);
      abschneiden := false;
      if i = n_xBeschriftung then
      begin
        abschneiden := true;
        for i := 0 to n_xBeschriftung do x_Beschriftung[i] :=
          copy(x_Beschriftung[i], 1, length(x_Beschriftung[i])-5)+
          copy(x_Beschriftung[i], length(x_Beschriftung[i])-3, 4);
      end;
    end;
  until (abschneiden = false);

  { y-Skalenweite }
  tmpR := (y_max-y_min)/8;
  str(tmpR, tmpS);
  ValueI(copy(tmpS, 2, 1), sig);
  ValueI(copy(tmpS, 19, 5), exp);
  case sig of
    0    : y_skal := 1;
    1    : y_skal := 2;
    2..4 : y_skal := 5;
    5..9 : y_skal := 10;
  end;
  y_skal := y_skal*(Zehnerpotenz(exp));

  { Mitte der y-Skala }
  skalmitte := (y_min+y_max)/2;
  if skalmitte >= 0 then
  begin
    tmpR := -y_skal;
    repeat
      tmpR := tmpR+y_skal;
    until skalmitte-tmpR <= 0;
    skalmitte := tmpR;
  end
  else
  begin
    tmpR := y_skal;
    repeat
      tmpR := tmpR-y_skal;
    until skalmitte-tmpR >= 0;
    skalmitte := tmpR;
  end;

  { y-Minimal- und -Maximal-Skalenwert }
  y_minskal := skalmitte;
  repeat
    y_minskal := y_minskal-y_skal;
  until y_minskal < y_min+0.1*y_skal;
  y_maxskal := skalmitte;
  repeat
    y_maxskal := y_maxskal+y_skal;
  until y_maxskal > y_max-0.1*y_skal;

  { y-Skalenbeschriftung }
  i := 0;
  tmpR := y_minskal;
  repeat
    tmpR := tmpR+y_skal;
    if abs(tmpR) > 0.5*y_skal then
    begin
      Str(tmpR, tmpS);
      if exp < 0 then
      begin
        if copy(tmpS, 4-exp, 1) = '9' then
        begin
          tmpR := tmpR+0.1*Zehnerpotenz(exp);
          Str(tmpR, tmpS);
        end;
        y_Beschriftung[i] :=
          copy(tmpS, 1, 3-exp)+copy(tmpS, 18, 2)+copy(tmpS, 22, 2);
      end
      else y_Beschriftung[i] :=
        copy(tmpS, 1, 4)+copy(tmpS, 18, 2)+copy(tmpS, 22, 2);
    end
    else
    begin
      tmpR := 0;
      y_Beschriftung[i] := '';
    end;
    inc(i);
  until tmpR >= y_maxskal-0.5*y_skal;
  n_yBeschriftung := i-1;

  { nichtsignifikante y-Stellen abschneiden }
  repeat
    abschneiden := false;
    if length(y_Beschriftung[i]) > 8 then
      begin
      i := -1;
      repeat
        abschneiden := false;
        inc(i);
        if copy(y_Beschriftung[i], length(y_Beschriftung[i])-4, 1) = '0'
          then abschneiden := true;
      until (abschneiden = false) or (i = n_yBeschriftung);
      abschneiden := false;
      if i = n_yBeschriftung then
      begin
        abschneiden := true;
        for i := 0 to n_yBeschriftung do y_Beschriftung[i] :=
          copy(y_Beschriftung[i], 1, length(y_Beschriftung[i])-5)+
          copy(y_Beschriftung[i], length(y_Beschriftung[i])-3, 4);
      end;
    end;
  until (abschneiden = false);

  { Umrechnungsfaktoren fr Bildschirmdarstellung }
  x_faktor := 600/(x_maxskal-x_minskal);
  y_faktor := 420/(y_maxskal-y_minskal);

  { x-Achse }
  if x_minskal < 0.5*x_skal then Skala[0] := 19 else Skala[0] := 39;
  if y_minskal > -0.5*y_skal then Skala[1] := 439
  else if y_maxskal < 0.5*y_skal then Skala[1] := 19
    else Skala[1] := -(round((-y_minskal)*y_faktor)-419)+19;
  if x_maxskal > -0.5*x_skal  then Skala[2] := 619 else Skala[2] := 599;

  { y-Achse }
  if x_minskal > -0.5*x_skal then Skala[3] := 19
  else if x_maxskal < 0.5*x_skal then Skala[3] := 619
    else Skala[3] := round((-x_minskal)*x_faktor)+19;
  if y_maxskal > -0.5*y_skal then Skala[4] := 19 else Skala[4] := 39;
  if y_minskal < 0.5*y_skal then Skala[5] := 439 else Skala[5] := 419;

  { Skalierungsfaktoren }
  Skala[6] := round(x_skal*x_faktor);
  Skala[7] := round(y_skal*y_faktor);

end; { SlalaBer }

{-------------------------------------------------------------------------}

{ Berechnung der Nhrung }
procedure Naehrung;

var
  h, s, y4, y5, k1, k2, k3, k4, k5, k6 : real;

begin
  y_min := y_anfang;
  y_max := y_anfang;
  x_last := x_min;
  y_last := y_anfang;
  h := (x_max-x_min)/100;
  repeat
    repeat

      { nchster x-Wert }
      x_next := x_last + h;

      { K-Werte }
      k1 := Rechne(FormelCode, x_last, y_last);
      k2 := Rechne(FormelCode, x_last+h/2, y_last+h*k1/2);
      k3 := Rechne(FormelCode, x_last+h/2, y_last+h*(k1+k2)/4);
      k4 := Rechne(FormelCode, x_last+h, y_last+h*(-k2+2*k3));
      k5 := Rechne(FormelCode, x_last+2*h/3, y_last+h*(7*k1+10*k2+k4)/27);
      k6 := Rechne(FormelCode, x_last+h/5,
              y_last+h*(28*k1-125*k2+546*k3+54*k4-378*k5)/625);

      { Nhrung 4. Ordnung }
      y4 := y_last+h*(k1+4*k3+k4)/6;

      { Nhrung 5. Ordnung }
      y5 := y_last+h*(14*k1+35*k4+162*k5+125*k6)/336;

      { s-Parameter }
      if y4 = y5 then s := 1 else s := sqrt(sqrt(h*e/abs(y4-y5)));

      { Schrittweite h verkleinern }
      if s < 1 then if s > 1/2 then h := s*h else h := h/2;

      { Schrittweite h zu klein, endlose Rekursion vermeiden }
      if h < (x_max-x_min)/1000000 then h := (x_max-x_min)/1000000;

    until (s >= 1) or (h  <= (x_max-x_min)/999999);

    { berechneten y-Wert bernehmen }
    y_next := y5;

    { Schrittweite h vergrern }
    if s >= 1 then if s < 2 then h := s*h else h := 2*h;

    { y-Grenzen }
    if y_next < y_min then y_min := y_next;
    if y_next > y_max then y_max := y_next;

    x_last := x_next;
    y_last := y_next;

  until x_last >= x_max;
end; { Naehrung }

{-------------------------------------------------------------------------}

{ Prfung ob Rechnung durchgefhrt werden kann und Start der Rechnung }
procedure Berechnung;

var
  Strng, Strng1, Strng2 : string;

begin
  FehlerCode := SetExit(CpuPointer);
  case FehlerCode of
    0   : begin
            Naehrung;
            SkalaBer;
            DarstellBer;
          end;
    200 : Strng := 'Division durch 0';
    205 : Strng := 'Fliekommaberlauf';
    206 : Strng := 'Fliekommazahl zu klein';
    207 : Strng := 'Unzulssige Werte'
    else  Strng := 'Rechenfehler unbekannter Art'
  end;
  if FehlerCode <> 0 then
  begin
    Str(x_last: 8: 3, Strng1);
    Strng1 := 'x = ' + Strng1;
    Str(y_last: 8: 3, Strng2);
    Strng2 := 'y = ' + Strng2;
    MessageBox(#3+Strng+#13+#3+Strng1+#13+#3+Strng2, nil,
      mfError or mfOKButton);
  end;
end; { Berechnung }

{-------------------------------------------------------------------------}

end. { Rechnung }

{-------------------------------------------------------------------------}